#pragma once

#include "gamestate.h"
#include "Level.h"



class CGSEdit : public CGameState
{

  public:

    enum Mode
    {
      MODE_TILE,
      MODE_UNIT,

      MODE_LAST_ENTRY
    };

    Level                   m_Level;

    Mode                    m_Mode;

    bool                    m_NameMode;

    LD10::GameObjectType    m_CurObj;

    LD10::TileTypes         m_CurTile;

    int                     m_CurLevel;

    bool                    m_ButtonReleased;

    int                     m_StartLifeTime;
    int                     m_UnitNumber;


    CGSEdit();
    virtual ~CGSEdit();

    virtual void            Display( IDirect3DDevice8* pDevice );

    virtual void            UpdateFrame( const float fElapsedTime );

    virtual void            OnChar( int iChar );
    virtual void            OnKeyDown( int iChar );

    virtual void            OnMouse( int iX, int iY, int iButtons );

};
